// SSIappView.cpp : implementation of the CSSIappView class
//

// This code is for demo purposes only to show how to use the ssidll import library and dll
// This demo also uses a jpeg decompression library which was made using the Independent JPEG Group's code. 


#include "stdafx.h"
#include "mainfrm.h"
#include "SSIapp.h"

#include "SSIappDoc.h"
#include "SSIappView.h"


#include "scandisp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


#include "ssidll.h"


#include "memdjpeg.h"


#define MAX_VIDEO_LEN 5000
unsigned char VideoData[MAX_VIDEO_LEN];
unsigned char *g_pImageData;

/////////////////////////////////////////////////////////////////////////////
// CSSIappView

IMPLEMENT_DYNCREATE(CSSIappView, CFormView)

BEGIN_MESSAGE_MAP(CSSIappView, CFormView)
	//{{AFX_MSG_MAP(CSSIappView)
	ON_BN_CLICKED(IDC_BUTTON_PULLTRIGGER, OnButtonPulltrigger)
	ON_BN_CLICKED(IDC_RADIO_CONNECT, OnRadioConnect)
	ON_BN_CLICKED(IDC_RADIO_Disconnect, OnRADIODisconnect)
	ON_BN_CLICKED(IDC_BUTTON_RELEASETRIGGER, OnButtonReleasetrigger)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT, OnButtonSnapshot)
	ON_BN_CLICKED(IDC_BUTTON_VIDEO, OnButtonVideo)
	ON_BN_CLICKED(IDC_BUTTON_ABORT, OnButtonAbort)
	ON_BN_CLICKED(IDC_CHECK_SWTRIGGER, OnCheckSwtrigger)
	ON_BN_CLICKED(IDC_CHECK_VIEWFINDER, OnCheckViewfinder)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_RADIO_115BAUD, OnRadio115baud)
	ON_BN_CLICKED(IDC_RADIO_COM2, OnRadioCom2)
	ON_BN_CLICKED(IDC_RADIO_COM3, OnRadioCom3)
	ON_BN_CLICKED(IDC_RADIO_COM4, OnRadioCom4)
	ON_BN_CLICKED(IDC_RADIO_9600BAUD, OnRadio9600baud)
	ON_BN_CLICKED(IDC_RADIO_38400BAUD, OnRadio38400baud)
	ON_BN_CLICKED(IDC_RADIO_COM1, OnRadioCom1)
	ON_BN_CLICKED(IDC_RADIO_JPEG, OnRadioJpeg)
	ON_BN_CLICKED(IDC_RADIO_TIFF, OnRadioTiff)
	ON_BN_CLICKED(IDC_RADIO_BMP, OnRadioBmp)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_EDIT_CLEAR, OnEditClear)
	ON_WM_DESTROY()
	ON_COMMAND(ID_PARAMETERS_GETSCANNERPARAMETER, OnParametersGetscannerparameter)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_EDIT_SELECT_ALL, OnEditSelectAll)
	ON_COMMAND(ID_VIEW_INTERPRETSPECIALS, OnViewInterpretspecials)
	ON_BN_CLICKED(IDC_RADIO_BAUD19200, OnRadioBaud19200)
	ON_BN_CLICKED(IDC_BUTTON_SENDCMD, OnButtonSendcmd)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_DECODE, OnSSIDecode)
	ON_MESSAGE(WM_SWVERSION, OnSSIVersion)
	ON_MESSAGE(WM_CAPABILITIES, OnSSICapabilities)
	ON_MESSAGE(WM_IMAGE, OnSSIImage)
	ON_MESSAGE(WM_XFERSTATUS, OnSSIxferStatus)
	ON_MESSAGE(WM_VIDEOIMAGE, OnSSIVideo)
	ON_MESSAGE(WM_ERROR, OnSSIError)
	ON_MESSAGE(WM_PARAMS, OnSSIParams)
	ON_MESSAGE(WM_TIMEOUT, OnSSITimeout)
	ON_MESSAGE(WM_EVENT, OnSSIEvent)
	ON_MESSAGE(WM_CMDCOMPLETEMSG, OnSSICommandCompleted)
	ON_MESSAGE(WM_USER_GETSWTRIGPARAM, OnGetSWTrigParam)
	ON_MESSAGE(WM_USER_GETIMAGETYPES, OnGetImageFileTypesParam)
	ON_MESSAGE(WM_USER_GETVIEWFINDERPARAM, OnGetViewFinderParam)
	ON_MESSAGE(WM_SENDGETVERSIONMSG, OnWM_SENDGETVERSIONMSG)
	ON_MESSAGE(WM_SENDGETCAPABILITIESMSG, OnWM_SENDGETCAPABILITIESMSG)
	ON_UPDATE_COMMAND_UI(ID_INDICATOR_MESSAGES, OnPrintMyMessage)
	ON_MESSAGE(WM_GOODBYE, OnParamMessage)
END_MESSAGE_MAP()

/////////////////////////////////
// SSI Comment:		The message handlers we added above are the handlers for the messages that are sent by the SSI dll 
//							with the exception of the WM_GOODBYE message and the ID_INDICATOR_MESSAGES message.
//							The WM_GOODBYE message is the message sent by the parameter setting/getting dialog when the user
//							exits the dialog.  The ID_INDICATOR_MESSAGES is the Command user interface message that is sent to 
//							us by Windows when the variable MyMessage is updated by any of our functions.  We have provided the
//							Handler for that here - PrintMyMessage. The text in the right hand side of the status bar will be
//							changed.
//							The indicators[] array in MainFrm.cpp has been altered to include ID_INDICATOR_MESSAGES  and 
//							an entry for that id was made in resouce.h along with an entry in the string table with the
//							initial value. 
/////////////////////////////////


CString CSSIappView::MyMessage = "";

// This function changes the message on the right hand side of the status bar, after the separator.
// This area is used to display what kind of message was received from the dll, e.g. "Recieved Decode"
afx_msg void CSSIappView::OnPrintMyMessage(CCmdUI *pCmdUI)
{

	pCmdUI->Enable();
	pCmdUI->SetText(MyMessage);

}

// This function changes the message on the left hand side of the status bar - the main pane of the status bar.
// We use this portion of the status bar to display status messages.
#define STRLEN_OF_INITSTRMSG 31 // "Waiting for Scanner Connection"
void CSSIappView::ChangeStatusBarText(CString msg)
{
//	CMainFrame * pFrame = (CMainFrame *)AfxGetApp()->m_pMainWnd;
//	CStatusBar * pStatus = (CStatusBar *) &pFrame->m_wndStatusBar;

	
//	if(msg.GetLength() < STRLEN_OF_INITSTRMSG)
//		pStatus->SetPaneText(0,msg);
//	else
//		pStatus->SetPaneText(0,"msg too big");

}


/////////////////////////////////////////////////////////////////////////////
// CSSIappView construction/destruction



CSSIappView::CSSIappView()
	: CFormView(CSSIappView::IDD)
{
	//{{AFX_DATA_INIT(CSSIappView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// TODO: add construction code here

	// These are our default settings when the view is constructed. 
	Baud = 115200;
	Comport = 1;
	Connected = FALSE;
	
	m_WaitingForSnapShot = FALSE;

	m_bWaitingForImageType = TRUE;			// On startup, we'll try to get these parameters from the scanner and
	m_bWaitingForSWTrigParam = TRUE;			// ... enable or disabled our controls accordingly.
	m_bWaitingForViewFinderParam = TRUE;	

	m_original_swtrigger = HOST_SWTRIG;		// Some scanners require users to set the trigger mode to host mode
														// ...Ones that don't have a param to set the trigger mode to host 
														// ...mode allow both host trigger and physical trigger.  That will be our
														// ... default here.

	m_ImageType = IMAGE_TYPE_UNKNOWN;		// We may not be connected to an imager.  Until we find out, we'll set these		
	m_bViewFinderSupported = FALSE;			// ...defaults.
	m_ImgFileExt = "";

	// We will use a modless dialog rather than a modal one since we can easily communicate our requests for data
	// ...and resposes from the scanner back and forth from the param dialog to this view and from the view to the
	// ...dialog.  So we'll instantiate it once here and get rid of it once in the destructor.  When the user selects
	// ...parameters on the menu, we'll create the window and when the user exits the dialog we'll destroy the window.
	// ...The dialog itself, however, will not be deleted until we're done with the view.
	pParamDlg = new CParamDlg(this);   
   
   g_pImageData = NULL;

}

CSSIappView::~CSSIappView()
{

	delete pParamDlg;  // We're done - time to get rid of the parameter dialog too.
   if(g_pImageData)
      delete [] g_pImageData;

}

void CSSIappView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSSIappView)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BOOL CSSIappView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs


	return CFormView::PreCreateWindow(cs);
}



// This is not itself a Message Handler -=- it's called  
// ...During the initial update - for now first_time is always set to FALSE 

void CSSIappView::ReInitialize(BOOL first_time)
{

	CButton *pButton;
	CEdit *pEdit;

	if(!first_time)  
	{

		m_WaitingForSnapShot = FALSE;	

		pEdit = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);  // Clear the scanner input area of the screen but leave it 
		pEdit->SetWindowText("");									// ...enabled - even if 
		pEdit->EnableWindow(1);										// ...we are not communicating with the scanner at the moment.
		GetDlgItem(IDC_EDIT_DECODEDATA)->SetFocus();

	}
	else
	{
		pEdit = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);	// On startup, we'll wait to enable until we have a connection.
		pEdit->EnableWindow(0);

	}


	

	pButton = (CButton *)GetDlgItem(IDC_CHECK_VIEWFINDER);
	pButton->EnableWindow(0);
	pButton = (CButton *)GetDlgItem(IDC_BUTTON_SNAPSHOT);
	pButton->EnableWindow(0);
	pButton = (CButton *)GetDlgItem(IDC_BUTTON_ABORT);
	pButton->EnableWindow(0);

	pButton = (CButton *)GetDlgItem(IDC_RADIO_TIFF);
	pButton->EnableWindow(0);
	pButton = (CButton *)GetDlgItem(IDC_RADIO_BMP);
	pButton->EnableWindow(0);
	pButton = (CButton *)GetDlgItem(IDC_RADIO_JPEG);
	pButton->EnableWindow(0);

	pButton = (CButton *)GetDlgItem(IDC_BUTTON_VIDEO);
	pButton->EnableWindow(0);

	pButton = (CButton *)GetDlgItem(IDC_CHECK_SWTRIGGER);
	pButton->EnableWindow(0);
	pButton = (CButton *)GetDlgItem(IDC_BUTTON_PULLTRIGGER);
	pButton->EnableWindow(0);
	pButton = (CButton *)GetDlgItem(IDC_BUTTON_RELEASETRIGGER);
	pButton->EnableWindow(0);

	


}


void CSSIappView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	CButton *pButton;
	

	// Set our controls to match what we've chosen to be the defaults - baud 115200, com1 and not connected.
	// Then call the function to disable everything else so the user can't do anything but connect.
	// That way they shouldn't get into trouble.

	pButton = (CButton *)GetDlgItem(IDC_RADIO_115BAUD);
	pButton->SetCheck(1);


	pButton = (CButton *)GetDlgItem(IDC_RADIO_COM1);
	pButton->SetCheck(1);

	pButton = (CButton *)GetDlgItem(IDC_RADIO_Disconnect);
	pButton->SetCheck(1);

	ReInitialize(FALSE);
	GetDlgItem(IDC_RADIO_Disconnect)->SetFocus();



	

}

/////////////////////////////////////////////////////////////////////////////
// CSSIappView diagnostics

#ifdef _DEBUG
void CSSIappView::AssertValid() const
{
	CFormView::AssertValid();
}

void CSSIappView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CSSIappDoc* CSSIappView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSSIappDoc)));
	return (CSSIappDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSSIappView message handlers

void CSSIappView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	
	// Do not call CFormView::OnPaint() for painting messages

	if(g_hImage != NULL)	// we were sent a valid image from the scanner so lets display it here.
	{
		CPaintDC *pdc = &dc;
		CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);
		RECT myRect;
		RECT editRect;
		RECT dlgRect;

		pEdit->GetWindowRect(&editRect);
		GetWindowRect(&dlgRect);

		int yoffset = editRect.top - dlgRect.top;
		int xoffset = editRect.left - dlgRect.left;

		pEdit->GetClientRect(&myRect);

		/* this is the rectangle of the edit box that we need to display images in */
		myRect.left += xoffset;
		myRect.right += xoffset;
		myRect.top += yoffset;
		myRect.bottom += yoffset;

		int indent = 10;
		int total_width = myRect.right - myRect.left - (indent * 2);
		
		myRect.left += indent;
		myRect.right -= indent;

		DisplayDIBSection (dc.m_hDC, g_hImage, 0, myRect.left, myRect.top, total_width, myRect.bottom - myRect.top);
	}	

}


// If the user trys to close the application before disconnecting, try to disconnect for them.
void CSSIappView::OnDestroy() 
{
	CFormView::OnDestroy();
	
	// TODO: Add your message handler code here
	if(Connected)
	{

		SSIDisconnect(m_hWnd, Comport);

		Sleep(100);
		Connected = FALSE;
		CMainFrame * pFrame = (CMainFrame *)AfxGetApp()->m_pMainWnd;  // Don't allow attempts to get and set params
		pFrame->m_Connected = FALSE;
		pFrame->m_ImgFileExtension = "";

	}
	if (g_hImage != NULL)
		DeleteObject (g_hImage);
	g_hImage = NULL;

	if(g_hPalette != NULL)
		DeleteObject(g_hPalette);
	g_hPalette = NULL;



	
}




//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//									MESSAGE HANDLERS FOR MESSAGES FROM THE SCANNER DLL
//
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////





// This function handles the WM_DECODE message from the scanner.  
// The SSI dll has issued a PostMessage - We want to respond to this message quickly
// Note that we also copy the data from the buffer we gave SSI dll into our own storage. 
//  

afx_msg LRESULT CSSIappView::OnSSIDecode(WPARAM w, LPARAM l)
{
	// wparam contains the status bits for the data , 
	// lparam is the length of the data in bytes (cast to int).
	unsigned char decode_buf[3001];
	

   
	// first thing is to copy the contents of the dll's data buffer to our own.
	if((l < 3000) && ((w & BUFFERSIZE_MASK) == BUFFERSIZE_GOOD ))
	{
		memcpy(decode_buf,VideoData,l);
		decode_buf[l] = 0;
	}
	else if( l && ((w & BUFFERSIZE_MASK) == BUFFERSIZE_ERROR ))
		strcpy((char *)decode_buf, "TOO MUCH DECODE DATA");
   else 
      strcpy((char *)decode_buf, "NO DECODE STORAGE BUFFER");
	decode_buf[3000] = 0;

	// Note that this display is not meant for binary data
	CEdit * pDecodeData = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);  

	// See if the user has unchecked the InterpretSpecials menu item.
	CMainFrame * pFrame = (CMainFrame *)AfxGetApp()->m_pMainWnd;
	if(pFrame->m_InterpretSpecials)  // if we're still processing the lower ASCII unprintable chars, do it and display
	{
		CString SpecialsInterpreted = decode_buf;  // CString will stop at the first null - so if data contains zeros,
																 // the first one will terminate the string.	

	
		SpecialsInterpreted.Replace("\001","<SOH>");
		SpecialsInterpreted.Replace("\002","<STX>");
		SpecialsInterpreted.Replace("\003","<ETX>");
		SpecialsInterpreted.Replace("\004","<EOT>");
		SpecialsInterpreted.Replace("\005","<ENQ>");
		SpecialsInterpreted.Replace("\006","<ACK>");
		SpecialsInterpreted.Replace("\007","<BEL>");

		SpecialsInterpreted.Replace("\010","<BS>");
		SpecialsInterpreted.Replace("\011","<HT>");
		SpecialsInterpreted.Replace("\012","<LF>");
		SpecialsInterpreted.Replace("\013","<VT>");
		SpecialsInterpreted.Replace("\014","<FF>");
		SpecialsInterpreted.Replace("\015","<CR>");
		SpecialsInterpreted.Replace("\016","<SO>");
		SpecialsInterpreted.Replace("\017","<SI>");


		SpecialsInterpreted.Replace("\020","<DLE>");
		SpecialsInterpreted.Replace("\021","<DC1>");
		SpecialsInterpreted.Replace("\022","<DC2>");
		SpecialsInterpreted.Replace("\023","<DC3>");
		SpecialsInterpreted.Replace("\024","<DC4>");
		SpecialsInterpreted.Replace("\025","<NAK>");
		SpecialsInterpreted.Replace("\026","<SYN>");
		SpecialsInterpreted.Replace("\027","<ETB>");


		SpecialsInterpreted.Replace("\030","<CAN>");
		SpecialsInterpreted.Replace("\031","<EM>");
		SpecialsInterpreted.Replace("\032","<SUB>");
		SpecialsInterpreted.Replace("\033","<ESC>");
		SpecialsInterpreted.Replace("\034","<FS>");
		SpecialsInterpreted.Replace("\035","<GS>");
		SpecialsInterpreted.Replace("\036","<RS>");
		SpecialsInterpreted.Replace("\037","<US>");

		SpecialsInterpreted.Replace("\177","<DEL>");

		pDecodeData->SetWindowText(SpecialsInterpreted);
	}
	else
		pDecodeData->SetWindowText((char *)decode_buf);  // display as is - no interpretation.  If unprintable chars, you
																		 // get what you get.  In real life, if an app is expecting 
																		 // binary data, it is processing it also and not displaying it.

	pDecodeData->ShowWindow(SW_SHOW);  // We're done with processing the input here.

	

	// Now reinit the image params and screen controls
	pFrame->m_ImgFileExtension = "";	// We won't allow any image file saving once the image is gone from the screen
	m_ImgFileExt = "";					// Keep our copy in sync with the status of the file->save availability
	ClearXferStatusMsg();				// get rid of any image transer status message that may have been displayed

	CString msg = "";
	ChangeStatusBarText(msg);
	MyMessage = "Received Decode";



	if(m_WaitingForSnapShot)   // We didn't get a timeout message or the image either - we got a decode instead. 
	{								   // This should never happen but is possible if waiting for snapshot when scanner was 
										// disconnected - dead, then reconnected and we didn't get a WM_SCANNERDEAD message.
		

		// if snapshot button was pressed, it was enabled previously therefore imaging was found to be supported on startup

		GetDlgItem(IDC_BUTTON_VIDEO)->EnableWindow(1);
		GetDlgItem(IDC_BUTTON_SNAPSHOT)->EnableWindow(1);
		if(m_bViewFinderSupported) 
			GetDlgItem(IDC_CHECK_VIEWFINDER)->EnableWindow(1); // keeps it's previously checked/unchecked state

		GetDlgItem(IDC_RADIO_BMP)->EnableWindow(1);				// keeps their previously selected state
		GetDlgItem(IDC_RADIO_TIFF)->EnableWindow(1);
		GetDlgItem(IDC_RADIO_JPEG)->EnableWindow(1);

		GetDlgItem(IDC_CHECK_SWTRIGGER)->EnableWindow(1);		// keeps it's previously checked/unchecked state

		msg = "Snapshot Timed Out - No T/O Msg Received";
		ChangeStatusBarText(msg);
		
		m_WaitingForSnapShot = FALSE;
	}
   SetDecodeBuffer(Comport, VideoData, MAX_VIDEO_LEN); // give the dll back the data it needs for the next decode
	return 1;
}


// This function handles the WM_IMAGE message from the scanner.  
// The SSI dll has issued a SendMessage - We want to respond to this message quickly .
afx_msg LRESULT CSSIappView::OnSSIImage(WPARAM w, LPARAM l)
{
	CString msg;
	unsigned char *pData = NULL;   //(unsigned char *) w;
	DWORD length = (DWORD)l;
	unsigned char *pImageType = pData;
	int filetype = IMAGE_TYPE_UNKNOWN;
	CMainFrame * pFrame = (CMainFrame *)AfxGetApp()->m_pMainWnd;  // This is our access to menu related stuff

   if((w & BUFFERSIZE_MASK) == BUFFERSIZE_GOOD)
	{
	   msg.Format("Image Complete");	// Main pane of status bar gives status
		pData = g_pImageData;
		pImageType = pData;
	}
   else if ((w & BUFFERSIZE_MASK) == BUFFERSIZE_ERROR)
      msg.Format("Image TOO BIG");	// Main pane of status bar gives status
   else
      msg.Format("NO Image BUFFER");	// Main pane of status bar gives status

	ChangeStatusBarText(msg);
	MyMessage = "Received Image";	// Right side tells what message we got from the dll

	OnSSIxferStatus((WPARAM)l,l);	// Update the transfer status display to show we got all of the expected image data


	// Since we are done with the transfer, we'll enable the user to do whatever they want again 
	// ...(as long as it's supported).

	GetDlgItem(IDC_BUTTON_VIDEO)->EnableWindow(1);
	GetDlgItem(IDC_BUTTON_SNAPSHOT)->EnableWindow(1);
	if(m_bViewFinderSupported)
		GetDlgItem(IDC_CHECK_VIEWFINDER)->EnableWindow(1);
	GetDlgItem(IDC_RADIO_BMP)->EnableWindow(1);
	GetDlgItem(IDC_RADIO_TIFF)->EnableWindow(1);
	GetDlgItem(IDC_RADIO_JPEG)->EnableWindow(1);
	GetDlgItem(IDC_CHECK_SWTRIGGER)->EnableWindow(1);


	// If the input data begins with "BM" it's a bitmap
	// Else if it starts with "MM" or "II" its a tiff - note that we expect big endian from the scanner, and ignore 
	// ...the II for indication for byte ordering.

   if(pImageType != NULL)
   {
   	if((*pImageType == 'B') && (*(pImageType +1) == 'M'))
	   {
		   filetype = BITMAP_TYPE;
		   SetupBMPforDisplay( pData,  l);			 // Process input and next Paint message will display our data
		   pFrame->m_ImgFileExtension = "bmp";  // Let user choose file save from menu, and set file filter to bmp extension.
	   }
	   else if (((*pImageType == 'M') && (*(pImageType +1) == 'M')) || ((*pImageType == 'I') && (*(pImageType +1) == 'I')))
	   {

		   SetupTIFFforDisplay( pData,  l);			// Process input and next Paint message will display our data
		   filetype = TIFF_TYPE;
		   pFrame->m_ImgFileExtension = "tif"; // Let user choose file save from menu, and set file filter to tif extension.
	   }
	   else if((*pImageType == 0xff) && (*(pImageType +1) == 0xd8))
	   {
		   filetype = JPEG_TYPE;	
			SetupJPEGforDisplay(pData,l, FALSE); // False indicates this is not video
		   							// Process input and next Paint message will display our data
													
		   pFrame->m_ImgFileExtension = "jpg";	// Let user choose file save from menu, and set file filter to jpg extension.
	   }
	   else
	   {
		   MessageBox("Unknown image format received");
		   pFrame->m_ImgFileExtension = "";		// This will indicate  file save from menu needs to be disabled.
	   }
	   m_ImgFileExt = 	pFrame->m_ImgFileExtension;	// Our copy, so we stay in sync with the menu.

	   if(filetype != IMAGE_TYPE_UNKNOWN)
		   WriteImgfile((LPTSTR)pData, length, filetype);	// We always write a temp file since we can't hang on to the
   }																	// ...dll's data to do it later.
	m_WaitingForSnapShot = FALSE;
	

	return 1;

}


// This function handles the WM_XFERSTATUS message from the scanner. It is also called by the handler for WM_IMAGE
// ...in order to update the screen display for data transferred. That is actually all this function does - displays
// ...the number of bytes transferred so far and the total number of bytes expected for the transfer.
//
// The SSI dll has issued a SendMessage - We want to respond to this message quickly so we won't block the SSI dll.
// Note that we also copy the data from the SSI dll into our own storage.  The buffer pointed to by WPARAM w belongs
// ...to the dll, not to us, so we only copy it's contents. We never change the contents.

afx_msg LRESULT CSSIappView::OnSSIxferStatus(WPARAM w, LPARAM l)
{
	CStatic *pStatus;
	CString msg;
	long running_total = (long)w;   // copy input and then we're done with the dll's data
	long expected_total = (long)l;
	
	
   if(running_total <= 255)  // this is the first packet of image data sent
   {
      if(g_pImageData)
	      delete [] g_pImageData;
	   g_pImageData = new BYTE[l + 1];
	   if(g_pImageData != NULL)
          SetImageBuffer(Comport, g_pImageData, l); // now  DLL has a place to put the image when done
   }

	msg.Format("Received %d of %ld", running_total, expected_total);

	pStatus = (CStatic *) GetDlgItem(IDC_STATIC_XFER);
	pStatus->SetWindowText(msg);

	return 1;
}



// This function handles the WM_VIDEO message from the scanner.  Note that this data comes as a jpeg file, just as 
// if it came from WM_IMAGE message in jpeg format.  The image data is sent to us directly, not the ssi preamble.
// The SSI dll has issued a Message - We want to respond to this message quickly.


afx_msg LRESULT CSSIappView::OnSSIVideo(WPARAM w, LPARAM l)

{


	// wparam is the status code for the data that was stored in the buffer we supplied to the dll 
	// lparam is the length of the data in bytes (cast to int).
	unsigned char *pData = VideoData;
	int length = (int)l;
	CString msg;
	


   if ((w & BUFFERSIZE_MASK) == BUFFERSIZE_ERROR) 
   {
      msg.Format("Image TOO BIG");	// Main pane of status bar gives status
		ChangeStatusBarText(msg);
		MyMessage = "Received Video Frame";	// Right side tells what message we got from the dll
   }
   else if ((w & BUFFERSIZE_MASK) == NOBUFFER_ERROR) 
   {
      msg.Format("NO Image BUFFER");	// Main pane of status bar gives status
		ChangeStatusBarText(msg);
		MyMessage = "Received Video Frame";	// Right side tells what message we got from the dll
   }
	else
		SetupJPEGforDisplay(pData, l, TRUE); // TRUE IS FOR VIDEO
	
	SetVideoBuffer(Comport, VideoData, MAX_VIDEO_LEN);  // reset for next time
	return 1;
}

void CSSIappView::SetupJPEGforDisplay(BYTE *pData, LPARAM length, BOOL is_video)
{		
	CString msg;
	
	if ( length)
	{
		HGLOBAL hImage;

		if(is_video)
			MyMessage = "Received Video Frame";	// Right side tells what message we got from the dll
		else
			MyMessage = "Received Image";	// Right side tells what message we got from the dll
		if((hImage = ReadJPEGBuffer(pData, length)) != NULL) 
		{
			CEdit * pDecodeData = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);


			RECT myRect;

			RECT editRect;
			pDecodeData->GetWindowRect(&editRect);		// rectangle where we display the decoded data when we're just scanning
																	// ... get it's coordinates on the screen
			RECT dlgRect;
			GetWindowRect(&dlgRect);						// rectangle of the entire dialog window - get it's coordinates too

			int yoffset = editRect.top - dlgRect.top;	// compute where the decoded data's rectangle is 
			int xoffset = editRect.left - dlgRect.left;

			pDecodeData->GetClientRect(&myRect);		// now get the width and height of the decoded data rectangle 

			/* this is the rectangle of the edit box that we need to display images in */
			myRect.left += xoffset;
			myRect.right += xoffset;
			myRect.top += yoffset;
			myRect.bottom += yoffset;

			int indent = 10;
			int total_width = myRect.right - myRect.left - (indent * 2);
	

			myRect.left += indent;
			myRect.right -= indent;
	
			myRect.bottom = myRect.top + (myRect.bottom - myRect.top);
	
			myRect.right = myRect.left + total_width;
	

			if(pDecodeData->IsWindowVisible())
				pDecodeData->ShowWindow(SW_HIDE);

			
			InvalidateRect(&myRect, FALSE);	// we want to re-draw this part
		
		}
		else
		{
			msg.Format("JFIF Null Image");	// Main pane of status bar gives status
			ChangeStatusBarText(msg);
			

		}
	}
	else
	{
		msg.Format("JFIF Null Image");	// Main pane of status bar gives status
		ChangeStatusBarText(msg);
		

	}
}




// This function handles the WM_SWVERSION message from the scanner.  
// We want to respond to this message quickly.  We don't want to block the SSI dll and we need to remember that 
// ...we are using the dll's data storage.  The data stored in the buffer will only remain valid for a short
// ...period of time.  We need to be ready for the next data transmission from the scanner as quickly as possible.
// Note that we also copy the data from the SSI dll into our own storage.  The buffer pointed to by WPARAM w belongs
// ...to the dll, not to us, so we only copy it's contents. We never change the contents.

afx_msg LRESULT CSSIappView::OnSSIVersion(WPARAM w, LPARAM l)
{
	CEdit *pEdit;
	char version_str[255 + 1] = {0};
	char version_str_w_lfs[300] = {0};
	char *pStrWlfs = version_str_w_lfs;
	unsigned char *pData;


   if ((w & BUFFERSIZE_MASK) == BUFFERSIZE_ERROR) 
   {
      strcpy(version_str, "Version TOO BIG");	// Main pane of status bar gives status
		l = 0;
   }
   else if((w & BUFFERSIZE_MASK) == NOBUFFER_ERROR) 
   {
      strcpy(version_str, "NO Version BUFFER");	// Main pane of status bar gives status
		l = 0;
   }
	else if(l==0)
		strcpy(version_str, "Version Data Error");
	else
		pData = VideoData; // using this buffer for everything except Video right now
	
	if(l && (l < 200))
	{
		memcpy(version_str,pData,l);
		version_str[l] = 0;
	}
	else if (l)
		memcpy(version_str, pData, 200);  // more data sent than expected - truncate it

	version_str[200] = 0;


	char *pChar = version_str;  // we are expecting a version string from the VS-4000
	char *pStart = version_str;

	if(pChar)
	{
		pChar = strchr(pStart,' '); // supposed to have space after sw revision  
		if(*pChar && l) // don't overwrite our buffer error message
		{
			*pChar = '\0';
			pChar++;
			strcpy(pStrWlfs, "Software Revision: ");
			strcat(pStrWlfs, pStart);
			
			pStrWlfs += strlen(version_str_w_lfs);
			pStart = pChar;
			*pStrWlfs++ = 0x0d;  // for display
			*pStrWlfs++ = 0x0a;
			*pStrWlfs = '\0';

			pChar = strchr(pStart,' '); // supposed to have space after board type
			if(pChar)
			{
				*pChar = '\0';
				pChar++;
				strcat(pStrWlfs, "Board Type: ");
				strcat(pStrWlfs, pStart);
				pStrWlfs = version_str_w_lfs + strlen(version_str_w_lfs);
				pStart = pChar;
				*pStrWlfs++ = 0x0d;  // for display
				*pStrWlfs++ = 0x0a;
				*pStrWlfs = '\0';

				pChar = strchr(pStart,' '); // supposed to have space after engine code 
				if(pChar)
				{
					*pChar = '\0';
					pChar++;
					strcat(pStrWlfs, "Engine Code: ");
					pStrWlfs += strlen("Engine Code: ");


					while(*pStart)
					{
						if((*pStart >= 0) && (*pStart <= 9))
							*pStrWlfs++ = (*pStart++ + '0');  // make digits ascii
						else
							*pStrWlfs++ = *pStart++; 
					}
					pStart = pChar;
					*pStrWlfs++ = 0x0d;  // for display
					*pStrWlfs++ = 0x0a;
					*pStrWlfs = '\0';
					if(strlen(pChar) >= 2)
					{
						strcat(pStrWlfs, "Program Checksum: ");
						pStrWlfs += strlen("Program Checksum: ");
						char mybuf[20];
						long prg_cksum = ((*pChar++) & 0x00ff) << 8;
						prg_cksum += (*pChar++) &0x00ff;
							if(strlen(pChar) == 2)
						{
							prg_cksum = prg_cksum << 16;
							prg_cksum += ((*pChar++) &0x00ff) << 8;
							prg_cksum += (*pChar++) &0x00ff;
						}
						if(!strlen(pChar))
						{
							itoa(prg_cksum, mybuf,16);
							strcat(pStrWlfs,mybuf);
						}
						else
							strcat(pStrWlfs,pStart);
					}
					else if (*pStart)
						strcat(pStrWlfs, pStart); // just append the rest to the end since it doesn't follow the spec
				}
				else  if (*pStart)
					strcat(pStrWlfs, pStart); // just append the rest to the end since it doesn't follow the spec
			}
			else  if (*pStart)
				strcat(pStrWlfs, pStart); // just append the rest to the end since it doesn't follow the spec	

		}
		else if (*pStart)
		{
			strcpy(pStrWlfs,pStart);
		}
	}


	pEdit = (CEdit *)GetDlgItem(IDC_EDIT_REVISION);
	pEdit->SetWindowText((char *) version_str_w_lfs);
	// now enable window controls
	pEdit = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);
	pEdit->EnableWindow(1);

	MyMessage = "Received Revision"; // leave other status msg alone

	SetVersionBuffer(Comport, VideoData, MAX_VIDEO_LEN); 	// give the dll the buffer back to fill in case there is a next time

	// Now get param for sw trigger and enable after getting current value
	// Notice that we don't just make the call here to get the parameter from the scanner.
	// We don't do that because we are still handling the previous transaction here, and need to release
	// ... the SSI protocol handler dll so that it can finish that transaction.  It can't begin a new
	// ... transaction until the last one has been completed.
	
	PostMessage(WM_SENDGETCAPABILITIESMSG, 0,0);  // put this message in the queue and we should be giving the ssi
	                                           // ... dll's timeslice enough time to finish doing what it's doing.

	return 1;
}


// if these become properties in a control, then any get function needs to return these as a param value and status
// of true or false for valid or invalid.  The values are only valid if the function is called after an event is fired
// and before the event handler returns.

BOOL bEvenParitySupported = 0;
BOOL bOddParitySupported = 0;
BOOL bNoParitySupported = 0;
BOOL bCheckParitySupported = 0;
BOOL bNoCheckParitySupported = 0;
BOOL bOneStopBitSupported = 0;
BOOL bTwoStopBitsSupported = 0;
BOOL bMultipacketOpt1Supported = 0;
BOOL bMultipacketOpt2Supported = 0;
BOOL bMultipacketOpt3Supported = 0;

LONG baudrates_supported[16] = {0};
SHORT nBaudRatesSupported = -1; // indicate we don't have data yet for this

LONG SSICommands_supported[253];
SHORT nSSICommandsSupported = -1; // indicate we don't have data yet for this

afx_msg LRESULT CSSIappView::OnSSICapabilities(WPARAM w, LPARAM l)
{
	CEdit *pEdit;
	char capabilities_str[256 + 1];
	CString S;
	unsigned char *pData;
	int i;


   if ((w & BUFFERSIZE_MASK) == BUFFERSIZE_ERROR) 
   {
      strcpy(capabilities_str, "Capabilities TOO BIG");	// Main pane of status bar gives status
		l = 0;
   }
   else if((w & BUFFERSIZE_MASK) == NOBUFFER_ERROR) 
   {
      strcpy(capabilities_str, "NO Capabilities BUFFER");	// Main pane of status bar gives status
		l = 0;
   }
	else if(l == 0)
		strcpy(capabilities_str, "Capabilities Data Bad");
	else
		pData = VideoData; // using this buffer for everything except Images right now


	if(l && (l < 256))
	{
		if(l < 5)
		{
			l = 0;
			strcpy(capabilities_str,"Capabilities Bad Format"); // didn't get min number to process
		}
		else
		{
			memcpy(capabilities_str,pData,l);
			capabilities_str[l] = 0;
		}
	}
	else if(l)  
	{
		l = 0;
		strcpy(capabilities_str,"Capabilities Data Bad"); // more data sent than expected
	
	}


	

	if(l ) // first 2 bytes are baudrates supported
	{
		unsigned char *pChar = (unsigned char *)capabilities_str;
		WORD bauds;
		BYTE misc;
		nBaudRatesSupported = 0;
		
		bauds = (*pChar++ << 8);
		bauds |= *pChar++;
		
		if(bauds & 0x0001)
			baudrates_supported[nBaudRatesSupported++] = 300;
		if(bauds & 0x0002)
			baudrates_supported[nBaudRatesSupported++] = 600;
		if(bauds & 0x0004)
			baudrates_supported[nBaudRatesSupported++] = 1200;
		if(bauds & 0x0008)
			baudrates_supported[nBaudRatesSupported++] = 2400;
		if(bauds & 0x0010)
			baudrates_supported[nBaudRatesSupported++] = 4800;
		if(bauds & 0x0020)
			baudrates_supported[nBaudRatesSupported++] = 9600;
		if(bauds & 0x0040)
			baudrates_supported[nBaudRatesSupported++] = 19200;
		if(bauds & 0x0080)
			baudrates_supported[nBaudRatesSupported++] = 28800;
		if(bauds & 0x0100)
			baudrates_supported[nBaudRatesSupported++] = 38400;
		if(bauds & 0x0200)
			baudrates_supported[nBaudRatesSupported++] = 57600;
		if(bauds & 0x0400)
			baudrates_supported[nBaudRatesSupported++] = 115200;
		// rest are reserved	
		l -= 2;

		misc = *pChar++;
		bOddParitySupported = (misc & 0x01);
		bEvenParitySupported = (misc & 0x02);
		bNoParitySupported = (misc & 0x04);
		bCheckParitySupported = (misc & 0x08);
		bNoParitySupported = (misc & 0x10);
		bOneStopBitSupported = (misc & 0x20);
		bTwoStopBitsSupported = (misc & 0x40);
		
		l -= 1;
		misc = *pChar++;
		bMultipacketOpt1Supported = (misc & 0x01);
		bMultipacketOpt2Supported = (misc & 0x02);	
		bMultipacketOpt3Supported = (misc & 0x04);

		l -=1;
		nSSICommandsSupported = 0; 
		for(int i = 0; i < l; i++)
			SSICommands_supported[nSSICommandsSupported++] = (LONG)(*pChar++ & 0x00ff);

			
	}
	else 
	{
		nBaudRatesSupported = -1;  // invalid data
		nSSICommandsSupported = -1;
	}
	
	
	/* NOW BUILD DISPLAY STRING */
		
	CString dispString;


	if((nBaudRatesSupported != -1) && (nSSICommandsSupported != -1))
	{
		dispString.Format("%d%s", nBaudRatesSupported, " BAUD RATES SUPPORTED: \015\012" );

		CString temp;

		for(  i = 0; i < nBaudRatesSupported; i++)
		{
			temp.Format("%d, ", baudrates_supported[i]);
			dispString += temp;
		}
	
		dispString += "\015\012Parity Options Supported: ";


		if(bOddParitySupported)
			dispString += "Odd Parity ";

		if(bEvenParitySupported)
			dispString += "Even Parity ";

		if(bNoParitySupported)
			dispString += "No Parity ";
	
		if(bCheckParitySupported)
			dispString += "Check Parity ";
		if(bNoCheckParitySupported)
			dispString += "No Parity Checking ";

		dispString += "\015\012Stop Bit Options Supported: ";
		if(bOneStopBitSupported)
			dispString += "One Stop Bit ";
		if(bTwoStopBitsSupported)
			dispString += "Two Stop Bits";

		dispString += "\015\012Multi-Packet Options Supported: ";
		if(bMultipacketOpt1Supported)
			dispString += "Option 1 ";
		if(bMultipacketOpt2Supported)
			dispString += "Option 2 ";
		if(bMultipacketOpt3Supported)
			dispString += "Option 3 ";

		dispString += "\015\012SSI Commands Supported: ";

		for(  i = 0; i < nSSICommandsSupported; i++)
		{
			temp.Format("%x, ", SSICommands_supported[i]);
			dispString += temp;
			if( i == 5)
				dispString += "\015\012";
		}
	}
	else
		dispString =  capabilities_str; // contains the errr message


	// now enable window controls
	pEdit = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);
	pEdit->EnableWindow(1);
	pEdit->SetWindowText(dispString);

	MyMessage = "Received Capabilities"; // leave other status msg alone


	// Now get param for sw trigger and enable after getting current value
	// Notice that we don't just make the call here to get the parameter from the scanner.
	// We don't do that because we are still handling the previous transaction here, and need to release
	// ... the SSI protocol handler dll so that it can finish that transaction.  It can't begin a new
	// ... transaction until the last one has been completed.
	

	SetCapabilitiesBuffer(Comport, VideoData, MAX_VIDEO_LEN); 	// give the dll the buffer back to fill in case there is a next

	PostMessage(WM_USER_GETSWTRIGPARAM, 0,0);  // put this message in the queue and we should be giving the ssi
	                                           // ... dll's timeslice enough time to finish doing what it's doing.

	return 1;
}






// This function handles the WM_ERROR message from the scanner.  
// We want to respond to this message quickly.  
afx_msg LRESULT CSSIappView::OnSSIError(WPARAM w, LPARAM l)
{
	// These messages are descriptions taken from the error codes in ssidll.h 
	CString msgs[40] = {
/*0*/		"No error", 
		"No connection established", 
		"The hwnd parameter to the Connect function was NULL - no connection established",
		"The library was unable to set the state of the com port - no connection established",
		"The library was unable to set the curent com timeouts - no connection established",   
/*5*/		"The library was unable to get the curent com timeouts - no connection established",   
		"The library was unable to get the curent com state - no connection established",   
		"Call to close com port was made when the com port is not open.  There is no connection.", 
		"Call to purge the com port before closing it was not successful.",
		"Fatal error - the threads didn't exit properly",
/*10*/		"Unable to lower DTR when closing com port", 
		"Unable to open the com port",
		"Unable to create the read/status thread - no connection.",
		"Unable to create the writer thread - no connection",
		"Call to CreateEvent failed - fatal error",
/*15*/		"Non fatal error - try your request again later",
		"Non fatal error - this command is not implemented in the library",
		"If already connected, can't call connect without a call to disconnect",
		"The hwnd paramter for the function does not match the stored hwnd for the connection",
		"The maximum allowable input data length was exceeded", 
/*20*/		"Can't run on this version of windows",
		"Please Retry - unable to add new user request to input queue for transmitting to scanner",
		"Param data is in incorrect format",
		"Wait for Multiple Objects gave WAIT_FAILED in writer proc ",
		"Failure to create write event - fatal error",
/*25*/		"Get overlapped result failed - fatal error", 
		"Number of bytes written is not the number requested to be written",
		"Wait multiple objects failure in overlapped write - fatal error",
		"Call to Write failed, but isn't just delayed - fatal error",
		"Write thread returned error on set event",
/*30*/		"Read thread bad overlapped result - fatal error",
		"Read thread bad set mask return - fatal error",
		"Read thread bad read - fatal error",
		"Read thread bad create read event",
		"Read thread bad create status event",
/*35*/		"Read thread wait com event bad return - fatal error",
		
		"Command was not processed successfully by decoder", 
		"Command was not processed successfully by decoder", 
		"Barcode packet was not of correct format from decoder for multipacketing",
		"State machine has received data that was unexpected for the current state",
		
	};



	int errcode = (w == 0)? 0: ((int)w * -1); // error codes are negative numbers - lets make them positive 
															// ... so they index the above array of constant strings.	
	if(errcode <= 39)
		MessageBox(msgs[errcode], "SSIdll Error");

	else
	{
		CString unknownerr;
		unknownerr.Format("Unknown Library Error: %ld", w);
		MessageBox(unknownerr, "SSIdll Error");
	}
	return 1;

}

// This function handles the WM_TIMEOUT message from the scanner.  
// We want to respond to this message quickly.  We don't want to block the SSI dll 
afx_msg LRESULT CSSIappView::OnSSITimeout(WPARAM w, LPARAM l)
{
	
	CString msg;

	if(m_WaitingForSnapShot)
	{
		GetDlgItem(IDC_BUTTON_VIDEO)->EnableWindow(1);
		GetDlgItem(IDC_BUTTON_SNAPSHOT)->EnableWindow(1);
		if(m_bViewFinderSupported)
			GetDlgItem(IDC_CHECK_VIEWFINDER)->EnableWindow(1);
		GetDlgItem(IDC_RADIO_BMP)->EnableWindow(1);
		GetDlgItem(IDC_RADIO_TIFF)->EnableWindow(1);
		GetDlgItem(IDC_RADIO_JPEG)->EnableWindow(1);
		GetDlgItem(IDC_CHECK_SWTRIGGER)->EnableWindow(1);
	}

	if(l == DECODE_DATA_TIMEOUT)
		msg = "Decode Timeout";
	else if(l == IMAGE_DATA_TIMEOUT)
		msg = "Image Timeout";
	else if (l == VIDEO_DATA_TIMEOUT)
		msg = "Vide Timeout";
	else
		msg.Format("Unknown Timeout: %ld", l);;
	ChangeStatusBarText(msg);
	MyMessage = "Timeout Received";


	m_WaitingForSnapShot = FALSE;

	return 1;
}

afx_msg LRESULT CSSIappView::OnSSICommandCompleted(WPARAM w, LPARAM l)
{
	CString msg = "Command Complete";
	ChangeStatusBarText(msg);
	MyMessage = "Command ACK Received";
	return 1;

}
// unsolicited event data from scanner
afx_msg LRESULT CSSIappView::OnSSIEvent(WPARAM w, LPARAM l)
{
	CString msg;
	CString dispString;
	CEdit *pEdit;

	dispString.Format("Event Data:  %x", w);
	pEdit = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);
	pEdit->EnableWindow(1);
	pEdit->SetWindowText(dispString);

	if(m_WaitingForSnapShot)
	{
		GetDlgItem(IDC_BUTTON_VIDEO)->EnableWindow(1);
		GetDlgItem(IDC_BUTTON_SNAPSHOT)->EnableWindow(1);
		if(m_bViewFinderSupported)
			GetDlgItem(IDC_CHECK_VIEWFINDER)->EnableWindow(1);
		GetDlgItem(IDC_RADIO_BMP)->EnableWindow(1);
		GetDlgItem(IDC_RADIO_TIFF)->EnableWindow(1);
		GetDlgItem(IDC_RADIO_JPEG)->EnableWindow(1);
		GetDlgItem(IDC_CHECK_SWTRIGGER)->EnableWindow(1);

		msg = "Snapshot Timed Out";
		ChangeStatusBarText(msg);
		MyMessage = "Event Data Received";


		m_WaitingForSnapShot = FALSE;
	}
	else
	{
		msg = "";
		ChangeStatusBarText(msg);
		MyMessage = "Event Data Received";
	}
	return 1;
}


// This function handles the WM_PARAMS message from the scanner.  
// We want to respond to this message quickly.  

afx_msg LRESULT CSSIappView::OnSSIParams(WPARAM w, LPARAM l)
{


	unsigned char *pParams = (unsigned char *) VideoData;
	int length = l;
	CButton *pButton;
	CString msg;

	if(m_bWaitingForSWTrigParam)  // we check to see if there is a separate param for setting the
	{										// trigger mode to host mode.  If so, we need to save the original value so
		if(l == 2)						// we can attempt to reset it later.
		{
			if(*pParams == SWTRIG_PARAMNUM)
			{
				pParams++;
				m_original_swtrigger = *pParams;
			}
		}
		else   // host sw trigger on/off is not supported as a separate param - it's allowed always - no need to reset it
			m_original_swtrigger = HOST_SWTRIG;


		pButton = (CButton *)GetDlgItem(IDC_CHECK_SWTRIGGER); // in either case, we allow use of software trigger
		pButton->EnableWindow(1);

		if(pButton->GetCheck())
		{
			pButton = (CButton *)GetDlgItem(IDC_BUTTON_PULLTRIGGER);
			pButton->EnableWindow(1);
			pButton = (CButton *)GetDlgItem(IDC_BUTTON_RELEASETRIGGER);
			pButton->EnableWindow(1);


		}

		m_bWaitingForSWTrigParam = FALSE;

		// WHEN CHECKED, ENABLE PULL AND RELEASE TRIGGER BUTTONS. 
		// WHEN disconnecting, if m_original_swtrigger is not HOST_SWTRIG, send message to user before disconnecting
		// ...to allow them to uncheck it before disconnecting


		MyMessage = "Param Received";
		// leave other status message alone
		SetParameterBuffer(Comport, VideoData, MAX_VIDEO_LEN); 	// give the dll the buffer back to fill in case there is a next

		PostMessage(WM_USER_GETIMAGETYPES, 0,0);  // After we get the param for host trigger mode, see if image types 
																// ...are supported.  We don't call the get params function here - we
																// ...instead send a message to ourseleves and the message handler will
																// ...make the call.  This gives the dll the ability to complete message
																// ...processing.
	}
	else if(m_bWaitingForImageType)		// Once we have sent the get image types we'll be back here when the scanner
	{												// ... replys with that param info.
		if(l == 3)
		{
			if((*pParams == EXTENDED_PARAMNUM) && (*(pParams + 1) == IMAGE_FILETYPE_PARAMNUM))
			{
				pParams++;
				pParams++;
				m_ImageType = (*pParams == JPEG_FILE_SELECTION)? JPEG_TYPE: 
				                    ((*pParams == BMP_FILE_SELECTION) ? BITMAP_TYPE: 
										  (*pParams == TIFF_FILE_SELECTION) ? TIFF_TYPE : IMAGE_TYPE_UNKNOWN);

				if(m_ImageType != IMAGE_TYPE_UNKNOWN)
				{
					pButton = (CButton *)GetDlgItem(IDC_BUTTON_SNAPSHOT);
					pButton->EnableWindow(1);

					pButton = (CButton *)GetDlgItem(IDC_BUTTON_ABORT);
					pButton->EnableWindow(1);

					pButton = (CButton *)GetDlgItem(IDC_RADIO_TIFF);
					pButton->EnableWindow(1);
					pButton = (CButton *)GetDlgItem(IDC_RADIO_BMP);
					pButton->EnableWindow(1);
					pButton = (CButton *)GetDlgItem(IDC_RADIO_JPEG);
					pButton->EnableWindow(1);

					pButton = (CButton *)GetDlgItem(IDC_BUTTON_VIDEO);
					pButton->EnableWindow(1);
				
					if(m_ImageType == JPEG_TYPE)
					{
						pButton = (CButton *)GetDlgItem(IDC_RADIO_BMP);
						pButton->SetCheck(0);
						pButton = (CButton *)GetDlgItem(IDC_RADIO_TIFF);
						pButton->SetCheck(0);

						pButton = (CButton *)GetDlgItem(IDC_RADIO_JPEG);
					}
					else if (m_ImageType == BITMAP_TYPE)
					{
						pButton = (CButton *)GetDlgItem(IDC_RADIO_JPEG);
						pButton->SetCheck(0);
						pButton = (CButton *)GetDlgItem(IDC_RADIO_TIFF);
						pButton->SetCheck(0);

						pButton = (CButton *)GetDlgItem(IDC_RADIO_BMP);
					}
					else
					{
						pButton = (CButton *)GetDlgItem(IDC_RADIO_BMP);
						pButton->SetCheck(0);
						pButton = (CButton *)GetDlgItem(IDC_RADIO_JPEG);
						pButton->SetCheck(0);

						pButton = (CButton *)GetDlgItem(IDC_RADIO_TIFF);
					}
					pButton->SetCheck(1);
					MyMessage = "Param Received";
				}
				else
					MyMessage = "Unknown Image Type";

			} // end paramnum is what we expected 
			else
				MyMessage = "No Image Params";
			

		} // end length was correct 
		else  // image types not supported
		{
			MyMessage = "No Image Params";

		}
		SetParameterBuffer(Comport, VideoData, MAX_VIDEO_LEN); 	// give the dll the buffer back to fill in case there is a next
		m_bWaitingForImageType = FALSE;
		PostMessage(WM_USER_GETVIEWFINDERPARAM, 0,0);   // we finished processing the image types, now check for viewfinder
	}																	// if we didn't get an image type that we understood, this will 	
	else if (m_bWaitingForViewFinderParam)					// most likely come back empty but we'll process the message anyway.
	{
		if(l == 3)
		{

			if((*pParams == EXTENDED_PARAMNUM) && (*(pParams + 1) == VIDEOVIEWFINDER_PARAMNUM))
			{
				pParams++;
				pParams++;
				pButton = (CButton *)GetDlgItem(IDC_CHECK_VIEWFINDER);
				pButton->EnableWindow(1);

				if(*pParams)
					pButton->SetCheck(1);
				else
					pButton->SetCheck(0);
				MyMessage = "Param Received";
				m_bViewFinderSupported = TRUE;
			}
			else
			{
				MyMessage = "No ViewFinder Param";
			}
		}
		else  // video viewfinder not supported
		{
			MyMessage = "No Viewfinder Mode";
		}
		msg = "Connected";
		ChangeStatusBarText(msg);
		m_bWaitingForViewFinderParam = FALSE;
	                   
		SetParameterBuffer(Comport, VideoData, MAX_VIDEO_LEN); 	// give the dll the buffer back to fill in case there is a next
	}
	else // got param from scanner - must have been a request from the param dialog box
	{

		MyMessage = "Param Received";
		unsigned char *pData = NULL;
		char error_str[100];

	   if ((w & BUFFERSIZE_MASK) == BUFFERSIZE_ERROR) 
		{
			strcpy(error_str, "PARAM STRING TOO BIG");	
			l = 0;
		}
		else if((w & BUFFERSIZE_MASK) == NOBUFFER_ERROR) 
		{
			strcpy(error_str, "NO PARAM BUFFER");	
			l = 0;
		}
		else if(l == 0)
			strcpy(error_str, "Paramaters Data Bad");
		else
			pData = VideoData; // using this buffer for everything except Images right now

		if(pData)
		{
			memcpy(pParamDlg->m_param_string,pData,l);  // copy the info from the scanner dll since it's only
			pParamDlg->m_param_string_len = l;					// valid for a short while.

			pParamDlg->PostMessage(WM_DISPLAYPARAM,0,0);  // post a message to display the input param in the param dialog window
		}
		else
		{
			MessageBox(error_str);
			SetParameterBuffer(Comport, VideoData, MAX_VIDEO_LEN); 	// give the dll the buffer back to fill in case there is a next
		}

	}

	return 1;
}



//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//		MESSAGE HANDLERS TO HANDLE THE MESSAGES WE'VE SENT TO OURSELVES FOR SETTING UP THE WINDOW CONTROLS
//
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////



// Here we handle the WM_SENDGERVERSIONMSG message that we put in the message queue.  
// This message is posted after the serial connection is made as we try to
// ...establish communicaion with the scanner.
afx_msg LRESULT CSSIappView::OnWM_SENDGETVERSIONMSG(WPARAM w, LPARAM l)
{
	CString msg;
	int error;

	Sleep(100);
	if((error = TransmitVersion(Comport)) )
	{
	
			
		OnSSIError((WPARAM) error, 0);
		msg = "Unable to Establish Communication - please disconnect and try again";
		ChangeStatusBarText(msg);
	}
	else
	{
		msg = "Requesting Version String";
		ChangeStatusBarText(msg);
	}
	return 1;

}

afx_msg LRESULT CSSIappView::OnWM_SENDGETCAPABILITIESMSG(WPARAM w, LPARAM l)
{
	CString msg;
	int error;

	Sleep(100);
	if((error = RequestScannerCapabilities(Comport)) )
	{
	
			
		OnSSIError((WPARAM) error, 0);
		msg = "Unable to get scanner capabilities - please disconnect and try again";
		ChangeStatusBarText(msg);
	}
	else
	{
		msg = "Requesting  Scanner Capabilites";
		ChangeStatusBarText(msg);
	}
	return 1;

}

// Here we handle the WM_USER_GETSWTRIGPARAM message that we put in the message queue when we handled the version
//... message from the scanner.  We'll wait a little longer, then send the message to request the swtrig param
afx_msg LRESULT CSSIappView::OnGetSWTrigParam(WPARAM w, LPARAM l)
{
	unsigned char Params[3];
	Params[0] = SWTRIG_PARAMNUM;
	Params[1] = 0;
	CString msg;
	int error;

	Sleep(50);
	if(error = RequestParameters(Params, 1, Comport))
	{
		OnSSIError((WPARAM) error, 0);
		msg = "";
		ChangeStatusBarText(msg);
		MyMessage = "";	
	}
	else
		MyMessage = "Sent SWTrig Param";


	return 1;
}

// After we receive the sw trigger param from the scanner, we'll post a message to ourselves to get get the image filetypes
// param from the scanner.
// Again, we can't just send off the next request while processing the scanner input because we must finish the current
// ... transaction before beginning a new one.  The only way to finish the transaction is to return control to the ssi
// ... dll.
afx_msg LRESULT CSSIappView::OnGetImageFileTypesParam(WPARAM w, LPARAM l)
{
	unsigned char Params[3];
	Params[0] = EXTENDED_PARAMNUM;
	Params[1] = IMAGE_FILETYPE_PARAMNUM;
	Params[2] = 0;
	CString msg;
	int error;

	Sleep(50);
	if(error = RequestParameters(Params, 2, Comport))
	{
		OnSSIError((WPARAM) error, 0);
		
		msg = "";
		ChangeStatusBarText(msg);
		MyMessage = "";
	}
	else
		MyMessage = "Sent Image Type Param";


	return 1;
}

// After we receive the image types param from the scanner, we'll post a message to ourselves to get get the video viewfinder
// param from the scanner.
// Again, we can't just send off the next request while processing the scanner input because we must finish the current
// ... transaction before beginning a new one.  The only way to finish the transaction is to return control to the ssi
// ... dll.
afx_msg LRESULT CSSIappView::OnGetViewFinderParam(WPARAM w, LPARAM l)
{
	unsigned char Params[3];
	Params[0] = EXTENDED_PARAMNUM;
	Params[1] = VIDEOVIEWFINDER_PARAMNUM;
	Params[2] = 0;
	CString msg;
	int error;


	Sleep(50);
	if(error = RequestParameters(Params, 2, Comport))
	{		
		OnSSIError((WPARAM) error, 0);
		
		msg = "";
		ChangeStatusBarText(msg);
		MyMessage = "";
	}
	else
		MyMessage = "Sent View Finder Param";
	
	return 1;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//									MESSAGE HANDLERS FROM THE DIALOG CONTROLS
//
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void CSSIappView::OnButtonPulltrigger() 
{

	// TODO: Add your control notification handler code here
	
	int error;
	CString msg;

	ClearXferStatusMsg();

	if(error = PullTrigger(Comport))
	{

		
		OnSSIError((WPARAM) error, 0);
		msg = "";
		ChangeStatusBarText(msg);
		MyMessage = "";


	}
	else
	{

		msg = "";
		ChangeStatusBarText(msg);
		MyMessage = "Pull Trigger Sent";

	}
	// After the trigger is pulled, snapshot mode is terminated - if there was an error and the trigger was unable to 
	// ... be pulled, then the scanner may still be in the waiting for snapshot mode.  However, if it is, it would not
	//... be too busy to service the trigger command above so this is very unlikely to happen.  
	// If viewfinder mode is on, snapshot timeout can occurr without the ssidll knowing about it so it will not send a timeout
	// ... message in that case to allow us to get out of snapshot mode.  So we are effectivly giving a way to re-enable
	// ... the controls here in the case of shapshot timeout with viewfinder mode on.  

	if(m_WaitingForSnapShot)  
	{
		GetDlgItem(IDC_BUTTON_VIDEO)->EnableWindow(1);
		GetDlgItem(IDC_BUTTON_SNAPSHOT)->EnableWindow(1);
		if(m_bViewFinderSupported)
			GetDlgItem(IDC_CHECK_VIEWFINDER)->EnableWindow(1);
		GetDlgItem(IDC_RADIO_BMP)->EnableWindow(1);
		GetDlgItem(IDC_RADIO_TIFF)->EnableWindow(1);
		GetDlgItem(IDC_RADIO_JPEG)->EnableWindow(1);
		GetDlgItem(IDC_CHECK_SWTRIGGER)->EnableWindow(1);
		m_WaitingForSnapShot = FALSE;
	}	
}



void CSSIappView::OnRadioConnect() // radio button for connect 
{
	// TODO: Add your control notification handler code here
	int error;
	CString msg;
	CButton * pButton;


	if((!Connected) && (((CButton*)GetDlgItem(IDC_RADIO_CONNECT))->GetCheck()))
	{
		msg = "Connecting... Please Wait";
		ChangeStatusBarText(msg);
		MyMessage = "";
		

																			
		if(error = SSIConnect(m_hWnd, Baud, Comport))
		{
						
			OnSSIError((WPARAM) error, 0);	

			msg = "Connection Failed - Try Changing Com Port Setting";
			ChangeStatusBarText(msg);


			pButton = (CButton *)GetDlgItem(IDC_RADIO_CONNECT);
			pButton->SetCheck(0);
			pButton = (CButton *)GetDlgItem(IDC_RADIO_Disconnect);
			pButton->SetCheck(1);

			// Everything else remains in it's disconnected state 
		}
		else
		{
			Connected = TRUE;
			// now disable the com settings and request info from the scanner so we know which controls to enable/disable
			pButton = (CButton *)GetDlgItem(IDC_RADIO_COM1);
			pButton->EnableWindow(0);
			pButton = (CButton *)GetDlgItem(IDC_RADIO_COM2);
			pButton->EnableWindow(0);
			pButton = (CButton *)GetDlgItem(IDC_RADIO_COM3);
			pButton->EnableWindow(0);
			pButton = (CButton *)GetDlgItem(IDC_RADIO_COM4);
			pButton->EnableWindow(0);


			pButton = (CButton *)GetDlgItem(IDC_RADIO_9600BAUD);
			pButton->EnableWindow(0);
			pButton = (CButton *)GetDlgItem(IDC_RADIO_BAUD19200);
			pButton->EnableWindow(0);

			pButton = (CButton *)GetDlgItem(IDC_RADIO_38400BAUD);
			pButton->EnableWindow(0);
			pButton = (CButton *)GetDlgItem(IDC_RADIO_115BAUD);
			pButton->EnableWindow(0);


			// REQUEST VERSION then when get version, we'll enable some controls 
			msg = "Trying to Establish Communication - please wait";
			ChangeStatusBarText(msg);

			CMainFrame * pFrame = (CMainFrame *)AfxGetApp()->m_pMainWnd;  // Allow attempts to get and set params
			pFrame->m_Connected = TRUE;
			PostMessage(WM_SENDGETVERSIONMSG, 0,0); 

			SetVideoBuffer(Comport, VideoData, MAX_VIDEO_LEN);
         SetDecodeBuffer(Comport, VideoData, MAX_VIDEO_LEN); // use is mutually exclusive so this is ok
         SetParameterBuffer(Comport, VideoData, MAX_VIDEO_LEN); // as long as we reset it as soon as we
         SetVersionBuffer(Comport, VideoData, MAX_VIDEO_LEN); // get the data
         SetCapabilitiesBuffer(Comport, VideoData, MAX_VIDEO_LEN); 
		}
	}
	else if (Connected)
	{
		msg = "Connection already established";
		ChangeStatusBarText(msg);
		MyMessage = "";

	}

	
}

void CSSIappView::OnRADIODisconnect() // radio button for disconnect
{

	int error;
	CString msg;
	CButton * pButton;
	CEdit *pEdit;
	BOOL cant_disconnect = FALSE;

	// TODO: Add your control notification handler code here

	if(((CButton*)GetDlgItem(IDC_RADIO_Disconnect))->GetCheck())  // if the disconnect button is checked
	{

		if(Connected && (m_original_swtrigger != HOST_SWTRIG))		// if we have changed the original value of host
		{																				// trigger mode on the scanner, give user chance to 
			pButton = (CButton *)GetDlgItem(IDC_CHECK_SWTRIGGER);		// reset it.  Note if params are not persistent, 
			if(pButton->GetCheck())												// they'll revert back on their own. 
			{
				if( IDYES == MessageBox("Trigger mode is in host mode. Do you want to continue with disconnect?", NULL, MB_YESNO))
					cant_disconnect = TRUE;
			}
		}
		if(Connected && m_WaitingForSnapShot && !cant_disconnect)
		{
			MessageBox("You have put scanner in snapshot mode. Please wait for timeout");
			cant_disconnect = TRUE;
		}
	
		if(Connected && !cant_disconnect)
		{
			// WHEN DISCONNECT, if m_original_swtrigger is not HOST_SWTRIG, send message to user before disconnecting
			// ...to allow them to uncheck it before disconnecting


			msg = "Trying to disconnect.....Please Wait";
			ChangeStatusBarText(msg);

			if(error = SSIDisconnect(m_hWnd, Comport))
			{
				OnSSIError((WPARAM) error, 0);

				pButton = (CButton *)GetDlgItem(IDC_RADIO_CONNECT);
				pButton->SetCheck(1);
				pButton = (CButton *)GetDlgItem(IDC_RADIO_Disconnect);
				pButton->SetCheck(0);
				// everything else remains in it's connected state
			}
			else
			{
				msg = "Disconnected.";
				ChangeStatusBarText(msg);
				MyMessage = "";

				Connected = FALSE;
				m_original_swtrigger = HOST_SWTRIG;
				m_WaitingForSnapShot = FALSE;
				m_bWaitingForImageType = TRUE;
				m_bWaitingForSWTrigParam = TRUE;
				m_bWaitingForViewFinderParam = TRUE;


				m_ImageType = IMAGE_TYPE_UNKNOWN;
				m_bViewFinderSupported = FALSE;

				CMainFrame * pFrame = (CMainFrame *)AfxGetApp()->m_pMainWnd;  // don't allow file save for last image if any
				pFrame->m_ImgFileExtension = "";
			
				pFrame->m_Connected = FALSE;

				m_ImgFileExt = "";

				pButton = (CButton *)GetDlgItem(IDC_RADIO_COM1);	// now enable the com settings controls to allow new connect
				pButton->EnableWindow(1);
				pButton = (CButton *)GetDlgItem(IDC_RADIO_COM2);
				pButton->EnableWindow(1);
				pButton = (CButton *)GetDlgItem(IDC_RADIO_COM3);
				pButton->EnableWindow(1);
				pButton = (CButton *)GetDlgItem(IDC_RADIO_COM4);
				pButton->EnableWindow(1);


				pButton = (CButton *)GetDlgItem(IDC_RADIO_9600BAUD);
				pButton->EnableWindow(1);
				pButton = (CButton *)GetDlgItem(IDC_RADIO_BAUD19200);
				pButton->EnableWindow(1);

				pButton = (CButton *)GetDlgItem(IDC_RADIO_38400BAUD);
				pButton->EnableWindow(1);
				pButton = (CButton *)GetDlgItem(IDC_RADIO_115BAUD);
				pButton->EnableWindow(1);


				pButton = (CButton *)GetDlgItem(IDC_CHECK_VIEWFINDER);  // disable everthing else since we're disconnected.
				pButton->EnableWindow(0);

				pButton = (CButton *)GetDlgItem(IDC_BUTTON_SNAPSHOT);
				pButton->EnableWindow(0);

				pButton = (CButton *)GetDlgItem(IDC_BUTTON_ABORT);
				pButton->EnableWindow(0);

				pButton = (CButton *)GetDlgItem(IDC_RADIO_TIFF);
				pButton->EnableWindow(0);
				pButton = (CButton *)GetDlgItem(IDC_RADIO_BMP);
				pButton->EnableWindow(0);
				pButton = (CButton *)GetDlgItem(IDC_RADIO_JPEG);
				pButton->EnableWindow(0);

				pButton = (CButton *)GetDlgItem(IDC_BUTTON_VIDEO);
				pButton->EnableWindow(0);


				pButton = (CButton *)GetDlgItem(IDC_CHECK_SWTRIGGER);
				if(pButton->GetCheck())  
					pButton->SetCheck(0);

				pButton = (CButton *)GetDlgItem(IDC_CHECK_SWTRIGGER);
				pButton->EnableWindow(0);
				pButton = (CButton *)GetDlgItem(IDC_BUTTON_PULLTRIGGER);
				pButton->EnableWindow(0);
				pButton = (CButton *)GetDlgItem(IDC_BUTTON_RELEASETRIGGER);
				pButton->EnableWindow(0);
				pEdit = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);
				pEdit->SetWindowText("");
				pEdit->ShowWindow(SW_SHOW);
				pEdit->EnableWindow(0);
				pEdit = (CEdit *)GetDlgItem(IDC_EDIT_REVISION);
				pEdit->SetWindowText("");


			

				ClearXferStatusMsg();
				if (g_hImage != NULL)
					DeleteObject (g_hImage);
				g_hImage = NULL;

				if(g_hPalette != NULL)
					DeleteObject(g_hPalette);
				g_hPalette = NULL;

				if(g_pImageData)
					delete [] g_pImageData;
				g_pImageData = NULL;
			}
		}
		else if(!Connected)
		{
			msg = "Status is Disconnected.";
			ChangeStatusBarText(msg);
			MyMessage = "";

		}
		else  // put buttons back the way they were since we can't disconnect
		{
			pButton = (CButton *)GetDlgItem(IDC_RADIO_CONNECT);
			pButton->SetCheck(1);
			pButton = (CButton *)GetDlgItem(IDC_RADIO_Disconnect);
			pButton->SetCheck(0);
			// leave status bar msgs as they were

		}
	}	
}



void CSSIappView::OnButtonReleasetrigger() 
{
	// TODO: Add your control notification handler code here

	int error;
	CString msg;

	if(m_WaitingForSnapShot)
	{
		MyMessage = "Release Trigger Ignored";
		return;
	}


	if((error = ReleaseTrigger(Comport)))
	{
		OnSSIError((WPARAM) error, 0);
		MyMessage = "";
	}
	else
	{
		MyMessage = "Release Trigger Sent";
		msg = "";
		ChangeStatusBarText(msg);
	}


	
}


void CSSIappView::OnButtonSnapshot() 
{
	// TODO: Add your control notification handler code here

	int error;
	CString msg;

	ClearXferStatusMsg();
	OnEditClear();

	if(m_WaitingForSnapShot)
	{
		MyMessage = "Button Press Ignored- waiting for trigger pull";
		return;
	}
	if(error = SnapShot(Comport))
	{
		OnSSIError((WPARAM) error, 0);
		MyMessage = "";
		msg = "";
		ChangeStatusBarText(msg);

	}
	else
	{
		if(((CButton *)GetDlgItem(IDC_CHECK_VIEWFINDER))->GetCheck())
		{
			msg = "Pull Trigger to take desired Snapshot";  // we will begin to get constant video stream until trigger pull
			ChangeStatusBarText(msg);
		}
		else
		{
			msg = "Pull Trigger within scanner timeout";
			ChangeStatusBarText(msg);
			m_WaitingForSnapShot = TRUE;
		}
		MyMessage = "Snapshot Sent";

		if(m_WaitingForSnapShot)
		{
			GetDlgItem(IDC_BUTTON_VIDEO)->EnableWindow(0);     // until trigger pull or timeout we won't allow any input
			GetDlgItem(IDC_CHECK_VIEWFINDER)->EnableWindow(0);
			GetDlgItem(IDC_RADIO_BMP)->EnableWindow(0);
			GetDlgItem(IDC_RADIO_TIFF)->EnableWindow(0);
			GetDlgItem(IDC_RADIO_JPEG)->EnableWindow(0);
			GetDlgItem(IDC_CHECK_SWTRIGGER)->EnableWindow(0);
		}
		CMainFrame * pFrame = (CMainFrame *)AfxGetApp()->m_pMainWnd;  // don't allow file save for last image if any
		pFrame->m_ImgFileExtension = "";
		m_ImgFileExt = "";


	}
	
}
	


void CSSIappView::OnButtonVideo() 
{
	// TODO: Add your control notification handler code here

	int error;
	CString msg;

	ClearXferStatusMsg();


	if(error = TransmitVideo(Comport))
	{
				
		OnSSIError((WPARAM) error, 0);
		MyMessage = "";
		msg = "";
		ChangeStatusBarText(msg);
		
	}
	else
	{
		CMainFrame * pFrame = (CMainFrame *)AfxGetApp()->m_pMainWnd;  // don't allow file save for last image if any
		pFrame->m_ImgFileExtension = "";
		m_ImgFileExt  = "";

		OnEditClear();
		msg = "Pull Trigger to begin Video";
		ChangeStatusBarText(msg);

		MyMessage = "Video Sent";
	}
}
	



void CSSIappView::OnButtonAbort() 
{
	// TODO: Add your control notification handler code here

	int error;
	CString msg;

	if(error = AbortImageXfer(Comport))
	{
		OnSSIError((WPARAM) error, 0);
		MyMessage = "";
	}
	else
	{
		MyMessage = "Abort Sent";
		if(m_WaitingForSnapShot)	// we will assume that if the msg was sent to the scanner, it will be successful
		{
			GetDlgItem(IDC_BUTTON_VIDEO)->EnableWindow(1);
			GetDlgItem(IDC_BUTTON_SNAPSHOT)->EnableWindow(1);
			if(m_bViewFinderSupported)
				GetDlgItem(IDC_CHECK_VIEWFINDER)->EnableWindow(1);
			GetDlgItem(IDC_RADIO_BMP)->EnableWindow(1);
			GetDlgItem(IDC_RADIO_TIFF)->EnableWindow(1);
			GetDlgItem(IDC_RADIO_JPEG)->EnableWindow(1);
			GetDlgItem(IDC_CHECK_SWTRIGGER)->EnableWindow(1);
				m_WaitingForSnapShot = FALSE;
		}

	}

	msg = "";
	ChangeStatusBarText(msg);


	
}

void CSSIappView::OnCheckSwtrigger() // we want to enable/disable the software trigger
{
	// TODO: Add your control notification handler code here

	int error = 0;
	CString msg;
	unsigned char parambuf[4];
	CButton *pButton = (CButton *)GetDlgItem(IDC_CHECK_SWTRIGGER); 
	BOOL is_checked;

	parambuf[0] = SWTRIG_PARAMNUM;
	parambuf[1] = HOST_SWTRIG;  
	parambuf[2] = 0x00;

	is_checked = pButton->GetCheck();

	if(m_original_swtrigger != HOST_SWTRIG) // need to send message to scanner 
	{
		if(is_checked)
			parambuf[1] = HOST_SWTRIG;				// button is checked, so enable sw trigger in scanner
		else
			parambuf[1] = m_original_swtrigger; // button is unchecked, so put it back the way it was on startup.

		if(error = SetParameters(parambuf, 2, Comport))
		{
			if(is_checked)
			{
				msg.Format("Error: %d  setting host trigger mode in scanner. Please try again.",error);
				pButton->SetCheck(0);
			}
			else
			{
				msg.Format("Error: %d  restoring trigger mode in scanner. Please try again",error);
				pButton->SetCheck(1);
			}
			MessageBox(msg);
			msg = "";
			ChangeStatusBarText(msg);
			MyMessage = "";
			
		}
		else
			MyMessage = "Trigger Mode Sent";
	}

	if(!error)	// if we were successful in setting up trigger control, then enable the pull and release buttons
	{				// ...according to the checked/unchecked status of the trigger control checkbox.
		if(is_checked)
		{
			pButton = (CButton *)GetDlgItem(IDC_BUTTON_PULLTRIGGER);
			pButton->EnableWindow(1);
			pButton = (CButton *)GetDlgItem(IDC_BUTTON_RELEASETRIGGER);
			pButton->EnableWindow(1);
			msg = "";
			ChangeStatusBarText(msg);
			

		}
		else
		{
			pButton = (CButton *)GetDlgItem(IDC_BUTTON_PULLTRIGGER);
			pButton->EnableWindow(0);
			pButton = (CButton *)GetDlgItem(IDC_BUTTON_RELEASETRIGGER);
			pButton->EnableWindow(0);
			msg = "";
			ChangeStatusBarText(msg);
		
			
		}


	}
}

void CSSIappView::OnCheckViewfinder()	// Shapshot mode will begin or not begin with video viewfinder depending on if this
{													// ... checkbox is checked or not.  If checkbox is disabled, video viewfinder is 
													// ... not available.
	// TODO: Add your control notification handler code here
	
	int error;
	CString msg;
	unsigned char parambuf[4];

	parambuf[0] = 0xf0;
	parambuf[1] = 0x44;
	parambuf[2] = 0x01;
	parambuf[3] = 0;

	if(((CButton *)GetDlgItem(IDC_CHECK_VIEWFINDER))->GetCheck())
		parambuf[2] = 0x01;
	else
		parambuf[2] = 0x00;

	if(error = SetParameters(parambuf, 3, Comport))
	{
		OnSSIError((WPARAM) error, 0);
		MyMessage = "";
		msg = "";
		ChangeStatusBarText(msg);

	}
	else
	{
		MyMessage = "Viewfinder Param Sent";
		if(parambuf[2]) // checked
			msg = "Press Snapshot to begin Video Preview";
		else
			msg = "After press Snapshot, press trigger for picture";
		ChangeStatusBarText(msg);
			
	}

}



void CSSIappView::OnRadioCom1() 
{
	// TODO: Add your control notification handler code here

	CString msg;

	Comport = 1;

	MyMessage = "No Connection";
	msg = "Com Port Setting Changed";
	ChangeStatusBarText(msg);

	
	
}

void CSSIappView::OnRadioCom2() 
{
	// TODO: Add your control notification handler code here

	CString msg;

	Comport = 2;
	MyMessage = "No Connection";
	msg = "Com Port Setting Changed";
	ChangeStatusBarText(msg);
	
}

void CSSIappView::OnRadioCom3() 
{
	// TODO: Add your control notification handler code here

	CString msg;

	Comport = 3;

	MyMessage = "No Connection";
	msg = "Com Port Setting Changed";
	ChangeStatusBarText(msg);
	
}

void CSSIappView::OnRadioCom4() 
{
	// TODO: Add your control notification handler code here

	CString msg;

	Comport = 4;

	MyMessage = "No Connection";
	msg = "Com Port Setting Changed";
	ChangeStatusBarText(msg);

	
}

void CSSIappView::OnRadio9600baud() 
{
	// TODO: Add your control notification handler code here

	CString msg;

	Baud = 9600;

	MyMessage = "No Connection";
	msg = "Baud Setting Changed";
	ChangeStatusBarText(msg);


}

void CSSIappView::OnRadioBaud19200() 
{
	// TODO: Add your control notification handler code here

	CString msg;

	Baud = 19200;

	MyMessage = "No Connection";
	msg = "Baud Setting Changed";
	ChangeStatusBarText(msg);

	
}


void CSSIappView::OnRadio115baud() 
{
	// TODO: Add your control notification handler code here

	CString msg;

	Baud = 115200;

	MyMessage = "No Connection";
	msg = "Baud Setting Changed";
	ChangeStatusBarText(msg);
	
}

void CSSIappView::OnRadio38400baud() 
{
	// TODO: Add your control notification handler code here
	CString msg;

	Baud = 38400;

	MyMessage = "No Connection";
	msg = "Baud Setting Changed";
	ChangeStatusBarText(msg);

	
}


void CSSIappView::OnRadioJpeg() 
{
	// TODO: Add your control notification handler code here
	SendImageFileSelection(JPEG_FILE_SELECTION, IDC_RADIO_JPEG, JPEG_TYPE );

}



void CSSIappView::OnRadioTiff() 
{
	// TODO: Add your control notification handler code here
	SendImageFileSelection(TIFF_FILE_SELECTION, IDC_RADIO_TIFF, TIFF_TYPE );
	
}

void CSSIappView::OnRadioBmp() 
{
	// TODO: Add your control notification handler code here
	SendImageFileSelection(BMP_FILE_SELECTION, IDC_RADIO_BMP, BITMAP_TYPE );
	
}

void CSSIappView::OnFileSaveAs() 
{
	// TODO: Add your command handler code here
	
	// TODO: Add your command handler code here
	CString filename;
	CString filter = m_ImgFileExt;
	CString savename;

	if(!filter.Compare("jpg"))
		savename = "jpeg.tmp";
	else if (!filter.Compare("tif"))
		savename = "tif.tmp";
	else if (!filter.Compare("bmp"))
		savename = "bmp.tmp";
	else 
		savename = "";

	if(savename.Compare("") == 0)
		MessageBox("Unable to save image file");
	else
	{
	
		filter.Format("Image files (*.%s)|*.%s||", m_ImgFileExt, m_ImgFileExt);

		CFileDialog myFileDlg(FALSE, m_ImgFileExt, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, filter, NULL);

		if(myFileDlg.DoModal() == IDOK)
		{
			filename = myFileDlg.GetPathName();

			CopyFile(savename, filename, FALSE);
		}
	}
	
}



//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//									MESSAGE HANDLERS FOR MESSAGES FROM THE MENU
//
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CSSIappView::OnEditClear() 
{
	// TODO: Add your command handler code here
	CEdit *pEdit = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);

	if(pEdit->IsWindowVisible())
		pEdit->SetWindowText("");
	else
	{
		pEdit->SetWindowText("");
		pEdit->ShowWindow(SW_SHOW);

		CMainFrame * pFrame = (CMainFrame *)AfxGetApp()->m_pMainWnd;  // don't allow file save for last image if any
		pFrame->m_ImgFileExtension = "";
		m_ImgFileExt = "";
	}
}

void CSSIappView::OnParametersGetscannerparameter() 
{
	// TODO: Add your command handler code here

	if(pParamDlg->GetSafeHwnd() == 0)
		pParamDlg->Create();  // display dlg window for getting and setting parameters
	
	
}

void CSSIappView::OnEditCopy() 
{
	// TODO: Add your command handler code here
	CEdit* pmyEdit = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);

	// Set the selection to be all characters after the current selection.
	
	pmyEdit->Copy();
	
}

void CSSIappView::OnEditSelectAll() 
{
	// TODO: Add your command handler code here
	CEdit* pmyEdit = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);

	// Set the selection to be all characters after the current selection.
	
	pmyEdit->SetSel(0, -1);

	

}

// menu choice for setting the lower ascii values to a string representation eg. value 0x02 as <STX>
void CSSIappView::OnViewInterpretspecials() 
{
	// TODO: Add your command handler code here
	CMainFrame * pFrame = (CMainFrame *)AfxGetApp()->m_pMainWnd;  

	if(pFrame->m_InterpretSpecials)
		pFrame->m_InterpretSpecials = FALSE;
	else
		pFrame->m_InterpretSpecials = TRUE;
	
}


//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//									MESSAGE HANDLERS FOR MESSAGES TO AND FROM THE PARAM DIALOG BOX
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Requesting parameters, setting parameters, and canceling the dialog box.
afx_msg LRESULT CSSIappView::OnParamMessage(WPARAM w, LPARAM l)
{
	int error;

	SetParameterBuffer(Comport, VideoData, MAX_VIDEO_LEN);
	
	if(w == IDCANCEL)
		pParamDlg->DestroyWindow();
	else if (w == ID_PARAMETERS_GETSCANNERPARAMETER)
	{
		
		if(error = RequestParameters((unsigned char *)pParamDlg->m_param_string, (int)pParamDlg->m_param_string_len, Comport))
		{
			OnSSIError((WPARAM) error, 0);
			CString msg = "";
			ChangeStatusBarText(msg);
			MyMessage = "";
		}
		else
			MyMessage = "Sent Param Request";
	}
	else
	{
		
		SetParamPersistance(Comport, pParamDlg->m_PermanentParamChange);
		if(error = SetParameters((unsigned char *)pParamDlg->m_param_string, (int)pParamDlg->m_param_string_len, Comport))
		{
			OnSSIError((WPARAM) error, 0);
			CString msg = "";
			ChangeStatusBarText(msg);
			MyMessage = "";
		}
		else
			MyMessage = "Sent Param Change";
	}
		
	return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//
//									Utility Functions used by the MESSAGE HANDLERS 
//
//
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////





// We want to change the image file type to bmp, tiff, or back to jpeg
void CSSIappView::SendImageFileSelection(BYTE file_selection, int nButtonID,  int new_filetype )
{
	CButton *pButton;
	unsigned char Params[4];
	int error = 0;
	CString msg;


	Params[0] = EXTENDED_PARAMNUM;
	Params[1] = IMAGE_FILETYPE_PARAMNUM;
	Params[2] = file_selection;
	Params[3] = 0;

	pButton = (CButton *)GetDlgItem(nButtonID);

	if(m_ImageType != new_filetype)
	{
		if(error = SetParameters(Params, 3, Comport))  // 3 is the length of Params
		{
			OnSSIError((WPARAM)error,0);
			pButton->SetCheck(0);
			if(m_ImageType == TIFF_TYPE)
				pButton = (CButton *)GetDlgItem(IDC_RADIO_TIFF);
			else if(m_ImageType == BITMAP_TYPE)
				pButton = (CButton *)GetDlgItem(IDC_RADIO_BMP);
			else
				pButton = (CButton *)GetDlgItem(IDC_RADIO_JPEG);

			pButton->SetCheck(1);
			MyMessage = "";
			msg = "";
			ChangeStatusBarText(msg);

		}
		else
		{
			MyMessage = "Image Type Param Sent";
			msg = "";
			ChangeStatusBarText(msg);

			m_ImageType = new_filetype;
		}
	}
	

}

void CSSIappView::ClearXferStatusMsg(void)
{
	CStatic *pStatus;
	CString XferStatusMsg;
	XferStatusMsg.Format("");
	pStatus = (CStatic *) GetDlgItem(IDC_STATIC_XFER);
	pStatus->SetWindowText(XferStatusMsg);


}

// Contents of a tiff file are stored in a memory buffer pointed to by w of length l.
// Sets the global handle g_hImage to the resulting handle to DIB and invalidates the rectangle where the DIB 
// ... is to be displayed when the PAINT message is received.

void CSSIappView::SetupTIFFforDisplay(unsigned char *pData, LPARAM l)
{

	int length = (int)l;
	CString ermsg;


	if (( pData != NULL ) && l)
	{
		HANDLE hDIB;

		hDIB = CreateDIBSectionFromTIFFFile( length, pData, m_hWnd );

		if (hDIB != NULL) 
		{
			if (g_hImage != NULL)
				DeleteObject (g_hImage);
			g_hImage = hDIB;

			if(g_hPalette != NULL)
				DeleteObject(g_hPalette);
			g_hPalette = GetPaletteHandle(m_hWnd,g_hImage);
		
		
			CEdit * pDecodeData = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);


			RECT myRect;

			RECT editRect;
			pDecodeData->GetWindowRect(&editRect);

			RECT dlgRect;
			GetWindowRect(&dlgRect);

			int yoffset = editRect.top - dlgRect.top;
			int xoffset = editRect.left - dlgRect.left;

			pDecodeData->GetClientRect(&myRect);

			/* this is the rectangle of the edit box that we need to display images in */
			myRect.left += xoffset;
			myRect.right += xoffset;
			myRect.top += yoffset;
			myRect.bottom += yoffset;

			int indent = 10;
			int total_width = myRect.right - myRect.left - (indent * 2);
	

			myRect.left += indent;
			myRect.right -= indent;
	
			myRect.bottom = myRect.top + (myRect.bottom - myRect.top);
	
			myRect.right = myRect.left + total_width;
	

			if(pDecodeData->IsWindowVisible())
				pDecodeData->ShowWindow(SW_HIDE);
			
			InvalidateRect(&myRect, FALSE);
		
		}
		else
			ermsg = "TIFF Null Image";
	}

}

// Contents of a bmp file are stored in a memory buffer pointed to by w of length l.
// Sets the global handle g_hImage to the resulting handle to DIB and invalidates the rectangle where the DIB 
// ... is to be displayed when the PAINT message is received.
void CSSIappView::SetupBMPforDisplay(unsigned char *pData, LPARAM l)
{
	


	// lparam is the length of the data in bytes (cast to int).
	
	int length = (int)l;
	CString ermsg;


	if (( pData != NULL ) && l)
	{
		HANDLE hDIB;

		hDIB = CreateDIBSectionFromDIBFile( length, pData, m_hWnd );

		if (hDIB != NULL) 
		{
			if (g_hImage != NULL)
				DeleteObject (g_hImage);
			g_hImage = hDIB;

			if(g_hPalette != NULL)
				DeleteObject(g_hPalette);
			g_hPalette = GetPaletteHandle(m_hWnd,g_hImage);

		
		
			CEdit * pDecodeData = (CEdit *)GetDlgItem(IDC_EDIT_DECODEDATA);


			RECT myRect;

			RECT editRect;
			pDecodeData->GetWindowRect(&editRect);

			RECT dlgRect;
			GetWindowRect(&dlgRect);

			int yoffset = editRect.top - dlgRect.top;
			int xoffset = editRect.left - dlgRect.left;

			pDecodeData->GetClientRect(&myRect);

			/* this is the rectangle of the edit box that we need to display images in */
			myRect.left += xoffset;
			myRect.right += xoffset;
			myRect.top += yoffset;
			myRect.bottom += yoffset;

			int indent = 10;
			int total_width = myRect.right - myRect.left - (indent * 2);
	

			myRect.left += indent;
			myRect.right -= indent;
	
			myRect.bottom = myRect.top + (myRect.bottom - myRect.top);
	
			myRect.right = myRect.left + total_width;
	

			if(pDecodeData->IsWindowVisible())
				pDecodeData->ShowWindow(SW_HIDE);
			
			InvalidateRect(&myRect, FALSE);
		
		}
		else
			ermsg = "BMP Null Image";
	}
	
	
}


// JPEG data is pointed to by pBuffer and it is of length cSize
// Uses the DJPEG LIBRARY to convert to a bitmap.  The bitmap is converted to
// a DIB section for display on the next PAINT message.
// 


HANDLE CSSIappView::ReadJPEGBuffer(BYTE *pBuffer, DWORD cSize)
{


	HANDLE hDIB; 
	HANDLE hTemp;
	size_t nBytesStored;
													
	nBytesStored = decodeJFIF(  pBuffer, (int) cSize, &hTemp );
	if(!hTemp)
		return NULL;

	if(!nBytesStored)
	{
		freeJFIFbmp(hTemp);
		return NULL;
	}

	hDIB = CreateDIBSectionFromDIBFile( nBytesStored, (unsigned char *)hTemp,m_hWnd);
	freeJFIFbmp(hTemp);
	
											  


	/* if valid DIBSection handle, then set to the global handle for display on next PAINT message */
	if (hDIB != NULL) 
	{
		if (g_hImage != NULL)
			DeleteObject (g_hImage);
		g_hImage = hDIB;
	}
	if(g_hPalette != NULL)
		DeleteObject(g_hPalette);
	g_hPalette = GetPaletteHandle(m_hWnd,g_hImage);
	
  
  return hDIB;

}


// Writes the image data to a temp file whenever snapshot data is sent from the scanner.
void CSSIappView::WriteImgfile(LPTSTR lpszStr, DWORD nBytes, int filetype)
{

	HANDLE output_file;
	char *jpeg_file = "jpeg.tmp";
	char *bmp_file = "bitmap.tmp";
	char *tiff_file = "tif.tmp";
	char *pfile;


	

	if(filetype == BITMAP_TYPE)
		pfile = bmp_file;
	else if (filetype == TIFF_TYPE)
		pfile = tiff_file;
	else
		pfile = jpeg_file;

	output_file = CreateFile(
						pfile,
						GENERIC_WRITE,	// access (read-write) mode
						FILE_SHARE_WRITE,	// share mode
						NULL, 			// pointer to security attributes
						CREATE_ALWAYS,		// how to create
						0,
						NULL			// handle to file with attributes to copy
						);
					
	if(output_file == INVALID_HANDLE_VALUE)
	{
		MessageBox("Cannot write temporary file", "Error",MB_OK);
		output_file = NULL;
		CMainFrame * pFrame = (CMainFrame *)AfxGetApp()->m_pMainWnd;  // don't allow file save for last image if any
		pFrame->m_ImgFileExtension = "";
		m_ImgFileExt = "";

	}
	else
	{
		DWORD NumberOfBytesWritten;
		WriteFile(output_file, (LPCVOID)lpszStr, nBytes, &NumberOfBytesWritten, NULL);
			
					
		if (!FlushFileBuffers(output_file))
			MessageBox("Failed flush file buffers", "Error",MB_OK);

		CloseHandle(output_file); 
	}

}




void CSSIappView::OnButtonSendcmd() 
{
	int cursel;
	CString msg;
	int error = 0;
	BYTE beepcode = 1;

	// TODO: Add your control notification handler code here
	CComboBox *pCombo = (CComboBox *)GetDlgItem(IDC_COMBO_COMMANDS);
	cursel = pCombo->GetCurSel();

	switch (cursel)
	{
	case 0:
		error = AimOn(Comport);
		break;
	case 1:
		error = AimOff(Comport);
		break;
	case 2:
		error = LedOn(Comport, beepcode); // double duty for led bit designator and beepcode
		break;
	case 3:
		error = LedOff(Comport, beepcode);
		break;
	case 4:
		error = ScanEnable(Comport);
		break;
	case 5:
		error = ScanDisable(Comport);
		break;
	case 6:
		error = SoundBeeper(Comport, beepcode);
		break;
	case 7:
		error = AbortMacroPdf(Comport);
		break;
	case 8:
		error = FlushMacroPdf(Comport);
		break;
	case 9:
		error = EnterLowPwrMode(Comport);
		break;
	default:
		error = 99; // generates unknow error command
	}
	if(error)
	{
		OnSSIError((WPARAM) error, 0);
		msg = "";
		ChangeStatusBarText(msg);
		MyMessage = "";
	}
	else
	{

		msg = "";
		ChangeStatusBarText(msg);
		MyMessage = "Command Sent";

	}

}
